import React, { useEffect } from 'react';
import { View, Text } from 'react-native';
import ParentComponent from './ParentComponent';
const App = () => {
  const updateAndMount = () => {
    console.log('App: componentDidMount called.');
    console.log('App: componentDidUpdate called.');
  }
  const willUnmount = () => {
    console.log('App: componentWillUnmount called.');
  }
  useEffect(
    () => {
      updateAndMount();
      return () => willUnmount();
    });

  return (
    <View style={{ flex: 1, justifyContent: 'center' }}>
      <Text style={{ fontSize: 50, fontWeight: 'bold' }}> LifeCyle Example</Text>
      <ParentComponent />
    </View >
  );

}
export default App;